set sql_safe_updates=0;
SET @dataproviderId2=(SELECT id FROM dydt_data_provider WHERE `providerName`='Visitor Details Provider');
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT 
T1.id AS id,
T1.personImagePath AS img_person,
T2.displayName AS academy_location_name,
T2.path AS img_academy_logo,
T1.meetingDate as meeting_date,
T1.visitorNo AS visitor_number,
T1.visitorCardNo AS visitor_card_number,
T1.visitorName AS visitor_name,
T1.visitorContactNo AS visitor_contact_no,
T1.visitorOrganization AS visitor_orgnization,
T1.visitorPlace AS visitor_place,
T1.reasonToVisit AS reason_for_meet,
T1.personToMeet AS person_to_meet,
T1.personContactNo AS person_contact_no,
T1.inTime AS in_time,
T1.outTime AS out_time,
	(CASE
        WHEN
            T1.isMultiDayPass IS NOT NULL
                AND T1.isMultiDayPass = true
        THEN
            "Yes"
        ELSE "No"
    END) AS multi_day_pass,
T1.tillDate AS till_date 
from 
sg_manage_visitors T1
left join academy_location T2 on T2.id = T1.academyLocationId'
WHERE
    `dataSourceCode` = 'VISITOR_DETAILS_INFO' AND dataProviderId = @dataproviderId2;
set sql_safe_updates=1;
 

